//
// The unofficial LEGO Mindstorms RCX SDK
// kmain.c - kernel main loop
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//
// I am heavily indebted to Kekoa for his first assembler firmware.
//

#include "stdlib.h"
#include "mm-internal.h"
#include "rcx-lcd.h"
#include "direct-button.h"
#include "rcx-sound.h"
#include "rcx-rom.h"
#include "conio.h"

extern int main(void);				// the user main()


///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// the beginning of everything C
// called by the assembler header
//
void kmain(size_t *sp) {
	int rc;
	int buttons;

#ifndef NO_TASK_MANAGEMENT
	tm_init();				// there is a task before
#endif						// there is memory :-)
	
#ifndef NO_MEMORY_MANAGEMENT	
	mm_init();				// we manage our memory.
#endif
	
	while(1) {
		set_firmware();			// tell kernel we're there.
		power_init();
		
		lcd_clear();
		lcd_show(man_stand);
		lcd_digit(0);			// initlevel 1. show until
		lcd_refresh();			// power key released.
	
		sound_system(1);		// wakeup sound
		while(PRESSED(button_state(),BUTTON_ONOFF))
			;			// wait for key release

		// kernel main loop.
		do {
			buttons=button_state();
			if(PRESSED(buttons,BUTTON_RUN)) {
				lcd_show(man_run);
				lcd_digit(1);
				lcd_refresh();
				sound_system(0);
				
				rc=main();	// run the app.
						// for now, part of the kernel
						// code.
				
				lcd_clear();
				lcd_show(man_stand);
				lcd_int(rc);	// show return code and
				lcd_digit(0);	
				lcd_refresh();
				sound_system(0);
				
#ifndef	NO_MEMORY_MANAGEMENT
				mm_reaper();	// clean up after single-tasking
#endif						// task.
				
			}
		} while(RELEASED(buttons,BUTTON_ONOFF));
		
		sound_system(0);		// sleep sound
//		while(sound_playing())		// let it complete.
//			;
		
		lcd_clear();			// remember, powerdown just
		lcd_refresh();			// puts the CPU to sleep.
		
		power_off();
	}
}
