;;
;; The unofficial LEGO Mindstorms RCX SDK
;; tm-asm.S - the assembler portion of task management
;; (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
;;

		.extern _tm_scheduler		; size_t *tm_scheduler(size_t*);
						; arg: old sp, retval: new sp
						
                .global _tm_switcher		; IRQ handler
						; store / restore all registers
						; do actual context switch.
						
.text
			
_tm_switcher:
		; r6 saved by ROM
		
		mov.w	r0,@-r7			; save all registers
		mov.w	r1,@-r7	
		mov.w	r2,@-r7		
		mov.w	r3,@-r7		
		mov.w	r4,@-r7		
		mov.w	r5,@-r7		
		
		mov.w	r7,r0			; pass stack ptr
		
		jsr	_tm_scheduler		; call C scheduler
		
		mov.w	r0,r7			; set new stack context
		
		sub	r0l,r0l
		mov.b	r0l,@0xd4:8		; clear counter
		bclr	#0x6,@0xd1:8		; clear count A event in T0_CSR
		
		mov.w	@r7+,r5			; restore all registers
		mov.w	@r7+,r4
		mov.w	@r7+,r3
		mov.w	@r7+,r2
		mov.w	@r7+,r1
		mov.w	@r7+,r0
		
		; r6 will be restored by ROM

		rts				; return to new task
; end of _tm_switcher
