//
// The unofficial LEGO Mindstorms RCX SDK
// tm.h - header file for task management
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __tm_h__
#define __tm_h__

#include "mem.h"

///////////////////////////////////////////////////////////////////////////////
//
// Definitions
//
///////////////////////////////////////////////////////////////////////////////

typedef unsigned char pstate_t;			// process state type

//
// process states
//

#define P_DEAD		0			// dead and gone, stack freed
#define	P_ZOMBIE	1			// terminated, cleanup pending
						// stack to be freed
#define P_SLEEPING	2			// sleeping. wants to run.
#define P_RUNNING	3			// running


#define DEFAULT_STACK_SIZE	1024		// 1k stack has to suffice.


//
// process data structure
//

typedef struct _process_data {
	size_t	*sp_save;			// stack save for context
						// switches
	
	pstate_t pstate;			// process state
		
	struct _process_data *next;		// next process in queue
	struct _process_data *prev;		// previous process in queue

	struct _process_data *parent;		// parent process

	size_t *stack_base;			// lower stack boundary
	
} process_data;

typedef size_t  pid_t;				// process id type
						// we just use (pid_t) &pdata
						// you saw this coming, huh?


	
///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// execute an image
// args: start address of code to execute
//       stack size for new process.
// retval: -1: fail, else pid
//
extern pid_t execi(int (*code_start)(void),size_t stack_size);

//
// exit task, returning code.
//
extern void exit(int code) __attribute__ ((noreturn));

#endif
