//
// The unofficial LEGO Mindstorms RCX SDK
// conio.c - console input / output
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef NO_CONSOLE_IO

#include "mem.h"
#include "conio.h"
#include "rcx-lcd.h"				// for lcd_refresh()
#include "direct-lcd.h"


///////////////////////////////////////////////////////////////////////////////
//
// Definitions
//
///////////////////////////////////////////////////////////////////////////////

//
// hex display codes
//
const char hex_display_codes[]={
	0x7e,	// 0
   	0x42,	// 1
   	0x37,	// 2
	0x67,	// 3
	0x4b,	// 4
	0x6d,	// 5
	0x7d,	// 6
	0x46,	// 7
	0x7f,	// 8
	0x4f,	// 9
	0x5f,	// A 
	0x79,	// b 
	0x31,	// c
	0x73,	// d 
	0x3d,	// E
	0x1d,	// F
};

#ifndef NO_ASCII

//
// ascii display codes
// only lower 128 bit, please!
//
const char ascii_display_codes[]={
	0x00,0x20,0x20,0x20,0x20,0x20,0x20,0x20,	// non-printables
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,	// -> underscore
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,	// except 0x00.
	0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
					
	0x00,	// 32 ' '
	0x42,	// 33 ! 1
	0x0a,	// 34 "
	0x7b,   // 35 #
	0x6d,	// 36 $ 5 S Z
	0x13,	// 37 % /
	0x7d,	// 38 & 6
	0x08,	// 39 '  alt: ` 
	0x3c,	// 40 ( C [ {
	0x66,	// 41 ) ] }
	0x5b,	// 42 * H K X
	0x43,	// 43 +  alt: 0x19 (worse)
	0x10,	// 44 , .  alt: 0x40
	0x01,	// 45 -
	0x10,	// 46 . alt: 0x40
	0x13,	// 47 /

	0x7e,	// 48 0 0
   	0x42,	// 49 1
   	0x37,	// 50 2
	0x67,	// 51 3
	0x4b,	// 52 4
	0x6d,	// 53 5
	0x7d,	// 54 6
	0x46,	// 55 7
	0x7f,	// 56 8
	0x4f,	// 57 9 Q q

	0x21,	// 58 : ; = alt:0x5 (worse)
	0x21,	// 59 ;
	0x31,	// 60 < c alt:0xd (worse)	
	0x21,	// 61 =
	0x61,	// 62 >   alt: 0x7 (worse)
	0x17,	// 63 ?
	0x3f,	// 64 @ alt: e
				
	0x5f,	// 65 A
	0x79,	// 66 b 
	0x3c,	// 67 C
	0x73,	// 68 d
	0x3d,	// 69 E
	0x1d,	// 70 F
	0x7c,	// 71 G
	0x5b,	// 72 H
	0x42,	// 73 I 1
	0x62,	// 74 J
	0x5b,	// 75 K
	0x38,	// 76 L
	0x5e,	// 77 M N
	0x5e,	// 78 N
	0x7e,	// 79 O alt: o
	0x1f,	// 80 P
	0x4f,	// 81 Q	
	0x11,	// 82 r
	0x6d,	// 83 S
	0x46,	// 84 T alt: t
	0x7a,	// 85 U V W
	0x7a,	// 86 V
	0x7a,	// 87 W
	0x5b,	// 88 X
	0x6b,	// 89 Y
	0x37,	// 90 Z

	0x3c,	// 91 [
	0x49,	// 92 '\\'
	0x66,	// 93 ]
	0x0e,	// 94 ^ ~
	0x20,	// 95 _
	0x02,	// 96 ` alt: '
	
	0x5f,	// 97 A R
	0x79,	// 98 b 
	0x31,	// 99 c
	0x73,	// 100 d 
	0x3d,	// 101 E
	0x1d,	// 102 F
	0x6f,	// 103 g
	0x59,	// 104 h
	0x42,	// 105 I 1
	0x62,	// 106 J alt 0x60 (worse)
	0x5b,	// 107 K alt h (worse?)
	0x38,	// 108 L
	0x51,	// 109 m n
	0x51,	// 110 n
	0x71,	// 111 o
	0x1f,	// 112 P
	0x4f,	// 113 q	
	0x11,	// 114 r
	0x6d,	// 115 S
	0x39,	// 116 t
	0x70,	// 117 u v w
	0x70,	// 118 v
	0x70,	// 119 w
	0x5b,	// 120 X
	0x6b,	// 121 Y
	0x37,	// 122 Z
	
	0x3c,	// 123 {
	0x18,	// 124 | (left) alt: 1 (worse)
	0x66,	// 125 }
	0x0e,	// 126 ~
	0x00	// 127 "" 127 empty
};

#endif 	// NO_ASCII

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// wait approx ms ms
//
void delay(unsigned ms) {
	unsigned i;
	while(ms-->0)
		for(i=0; i<600; i++)	// not well calibrated.
			;

}

//
// display native mode segment mask at display position pos
//
// encoding: middle=1, topr=2, top=4, ... (counterclockwise)
// dot not included because not reliably present.
//
void cputc_native(char mask,int pos) {
	switch(pos) {
	case 0:
		cputc_native_0(mask);
		break;
	case 1:
		cputc_native_1(mask);
		break;
	case 2:
		cputc_native_2(mask);
		break;
	case 3:
		cputc_native_3(mask);
		break;
	case 4:
		cputc_native_4(mask);
		break;
	case 5:
		cputc_native_5(mask);
	}
}			

//
// display native mode segment mask at fixed display position
//
// encoding: middle=1, topr=2, top=4, ... (counterclockwise)
// dot not included because not reliably present.
//
void cputc_native_0(char mask) {
	// gcc is stupid
	// doesn't re-use constant values in registers.
	// re-ordered stores to help him.
					
	bit_load(mask,0x2);
	dlcd_store(LCD_0_TOP);
	bit_load(mask,0x0);
	dlcd_store(LCD_0_MID);
	bit_load(mask,0x5);
	dlcd_store(LCD_0_BOT);
	bit_load(mask,0x1);
	dlcd_store(LCD_0_TOPR);
	bit_load(mask,0x6);
	dlcd_store(LCD_0_BOTR);
	bit_load(mask,0x3);
	dlcd_store(LCD_0_TOPL);
	bit_load(mask,0x4);
	dlcd_store(LCD_0_BOTL);
}

//
// display native mode segment mask at fixed display position
//
// encoding: middle=1, topr=2, top=4, ... (counterclockwise)
// dot not included because not reliably present.
//
void cputc_native_1(char mask) {
	bit_load(mask,0x2);
	dlcd_store(LCD_1_TOP);
	bit_load(mask,0x0);
	dlcd_store(LCD_1_MID);
	bit_load(mask,0x5);
	dlcd_store(LCD_1_BOT);
	bit_load(mask,0x1);
	dlcd_store(LCD_1_TOPR);
	bit_load(mask,0x6);
	dlcd_store(LCD_1_BOTR);
	bit_load(mask,0x3);
	dlcd_store(LCD_1_TOPL);
	bit_load(mask,0x4);
	dlcd_store(LCD_1_BOTL);
}

//
// display native mode segment mask at fixed display position
//
// encoding: middle=1, topr=2, top=4, ... (counterclockwise)
// dot not included because not reliably present.
//
void cputc_native_2(char mask) {
	bit_load(mask,0x2);
	dlcd_store(LCD_2_TOP);
	bit_load(mask,0x0);
	dlcd_store(LCD_2_MID);
	bit_load(mask,0x5);
	dlcd_store(LCD_2_BOT);
	bit_load(mask,0x1);
	dlcd_store(LCD_2_TOPR);
	bit_load(mask,0x6);
	dlcd_store(LCD_2_BOTR);
	bit_load(mask,0x3);
	dlcd_store(LCD_2_TOPL);
	bit_load(mask,0x4);
	dlcd_store(LCD_2_BOTL);
}

//
// display native mode segment mask at fixed display position
//
// encoding: middle=1, topr=2, top=4, ... (counterclockwise)
// dot not included because not reliably present.
//
void cputc_native_3(char mask) {
	bit_load(mask,0x2);
	dlcd_store(LCD_3_TOP);
	bit_load(mask,0x0);
	dlcd_store(LCD_3_MID);
	bit_load(mask,0x5);
	dlcd_store(LCD_3_BOT);
	bit_load(mask,0x1);
	dlcd_store(LCD_3_TOPR);
	bit_load(mask,0x6);
	dlcd_store(LCD_3_BOTR);
	bit_load(mask,0x3);
	dlcd_store(LCD_3_TOPL);
	bit_load(mask,0x4);
	dlcd_store(LCD_3_BOTL);
}

//
// display native mode segment mask at fixed display position
//
// encoding: middle=1, topr=2, top=4, ... (counterclockwise)
// dot not included because not reliably present.
//
void cputc_native_4(char mask) {
	bit_load(mask,0x2);
	dlcd_store(LCD_4_TOP);
	bit_load(mask,0x0);
	dlcd_store(LCD_4_MID);
	bit_load(mask,0x5);
	dlcd_store(LCD_4_BOT);
	bit_load(mask,0x1);
	dlcd_store(LCD_4_TOPR);
	bit_load(mask,0x6);
	dlcd_store(LCD_4_BOTR);
	bit_load(mask,0x3);
	dlcd_store(LCD_4_TOPL);
	bit_load(mask,0x4);
	dlcd_store(LCD_4_BOTL);
}

//
// display native mode segment mask at fixed display position
//
// encoding: middle=1, topr=2, top=4, ... (counterclockwise)
// dot not included because not reliably present.
//
void cputc_native_5(char mask) {
	bit_load(mask,0x0);
	dlcd_store(LCD_5_MID);
}	

void cputw(unsigned word) {
	unsigned char *ptr=(unsigned char*) &word;
	
	cputc_native_3(hex_display_codes[(*ptr)&0xf]);
	cputc_native_4(hex_display_codes[(*ptr)>>4]);
	cputc_native_1(hex_display_codes[(*(++ptr))&0xf]);
	cputc_native_2(hex_display_codes[(*ptr)>>4]);
}

#ifndef NO_ASCII

//
// display a zero terminated string s
//
void cputs(unsigned char *s) {
	unsigned char b4=0,b3=0,b2=0,b1=0,b0=0;
	int wait=0;

	while(*s || wait!=3) {
		b4=b3;
		b3=b2;
		b2=b1;
		b1=b0;
		b0=ascii_display_codes[(*s)];
		
		// double m,w to increase realism.
		if(*s=='w' || *s=='W' || *s=='m' || *s=='M') {
			if((wait++)) {
				wait=0;
				s++;
			}
		} else if(!*s) {		// 0: scroll out.
			b0=0;
			wait++;
		}
		else				// all else: scroll
			s++;
			
		cputc_native_0(b0);
		cputc_native_1(b1);
		cputc_native_2(b2);
		cputc_native_3(b3);
		cputc_native_4(b4);
		
		lcd_refresh();
		if(wait!=3)
			delay(SCROLL_DELAY); 
	} 
			
}

#endif // NO_ASCII

#endif 	// NO_CONSOLE_IO
