//
// The unofficial LEGO Mindstorms RCX SDK
// direct-ir.h - direct IR port access header
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __direct_ir_h__
#define __direct_ir_h__

#ifndef NO_DIRECT_IR

#include "mem.h"

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// initialize IR port
//
extern void dir_init(void);


//
// shutdown IR port
//
extern void dir_shutdown(void);


//
// write to IR port, blocking.
// return code: nr of bytes written. -1 -> error.
//
extern size_t dir_write(void* const buf,size_t len);


//
// read from IR port, blocking.
// return code: nr of bytes written. -1 -> error.
//
extern size_t dir_read(void* buf,size_t len);

#endif	// NO_DIRECT_IR

#endif
