//
// The unofficial LEGO Mindstorms RCX SDK
// direct-motor.c - direct motor access
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef NO_DIRECT_MOTOR

#include "direct-motor.h"
#include "h8.h"
#include "rcx-irq.h"


///////////////////////////////////////////////////////////////////////////////
//
// Variables
//
///////////////////////////////////////////////////////////////////////////////

volatile unsigned char dm_a_count,			// motor pcm counter
		       dm_b_count,			// changed by irq
		       dm_c_count;
		
unsigned char	dm_a_period,				// motor pcm period
		dm_b_period,
		dm_c_period;

unsigned char	dm_a_dir,				// motor direction
		dm_b_dir,				// must be set from
		dm_c_dir;				// the patterns below

const unsigned char dm_a_pattern[]={0x00,0x80,0x40,0xc0},// motor drive patterns
		    dm_b_pattern[]={0x00,0x08,0x04,0x0c},// to be indexed with
		    dm_c_pattern[]={0x00,0x02,0x01,0x03};// MotorDirections


///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// direct motor output handler for the 16bit timer OCIA irq
//
extern void dm_handler(void);

__asm__("
.text
.align 1
.global _dm_handler
_dm_handler:
		; r6 saved by ROM
		mov.w	r0,@-r7			; save r0
				
		sub.w	r6,r6			; r6l is output
		
		mov.b	@_dm_a_count,r0l	; counter 1 elapsed?
		bne	0f
		
		  mov.b	@_dm_a_dir,r6h		; output pattern
		  or.b	r6h,r6l
		  mov.b	@_dm_a_period,r0l	; recharge counter
		  
	      0:dec	r0l
	        mov.b	r0l,@_dm_a_count	; save counter
		  
		
		mov.b	@_dm_b_count,r0l	; counter 2 elapsed?
		bne	1f
		
		  mov.b	@_dm_b_dir,r6h		; output pattern
		  or.b	r6h,r6l
		  mov.b	@_dm_b_period,r0l	; recharge counter
		  
	      1:dec	r0l
	        mov.b	r0l,@_dm_b_count	; save counter
		  
		
		mov.b	@_dm_c_count,r0l	; counter 3 elapsed?
		bne	2f
		
		  mov.b	@_dm_c_dir,r6h		; output pattern
		  or.b	r6h,r6l
		  mov.b	@_dm_c_period,r0l	; recharge counter
		  
	      2:dec	r0l
	        mov.b	r0l,@_dm_c_count	; save counter
		  
		mov.b	r6l,@0xf000:16		; output motor waveform
		
		bclr	#3,@0x91:8		; reset compare A IRQ flag
		
		mov.w @r7+,r0			; restore r0
		
		rts		
	");
	
		
//
// initialize motors
//
void dm_init(void) {
	dm_shutdown();				// shutdown hardware
		
	motor_a_dir(off);			// initialize driver data
	motor_b_dir(off);
	motor_c_dir(off);
	
	motor_a_speed(MIN_SPEED+(MAX_SPEED-MIN_SPEED)/2);
	motor_b_speed(MIN_SPEED+(MAX_SPEED-MIN_SPEED)/2);
	motor_c_speed(MIN_SPEED+(MAX_SPEED-MIN_SPEED)/2);
		
	dm_a_count=dm_b_count=dm_c_count=0;
	
	// FIXME: assuming timing is set up correctly by ROM
	//
	OCIA_IRQ=&dm_handler;			// hook compare A IRQ
	T_CSR&=~TCSR_MATCH_A;			// clear flag
	T_IER|=TIER_ENABLE_IRQA;
}


//
// shutdown motors
//
void dm_shutdown(void) {
	T_IER&=~TIER_ENABLE_IRQA;		// unhook compare A IRQ
	RCX_MOTORS=0x00;			// shutdown hardware
}

#endif
