//
// The unofficial LEGO Mindstorms RCX SDK
// direct-motor.h - direct motor access header
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef	__direct_motor_h__
#define __direct_motor_h__

#ifndef NO_DIRECT_MOTOR

///////////////////////////////////////////////////////////////////////////////
//
// Definitions
//
///////////////////////////////////////////////////////////////////////////////

typedef enum {
	off=0,
	fwd=1,
	rev=2,
	brake=3
			
}
	MotorDirection;					// motor directions

#define  MIN_SPEED	1				// minimum speed
#define  MAX_SPEED	8				// maximum speed


///////////////////////////////////////////////////////////////////////////////
//
// Variables
//
///////////////////////////////////////////////////////////////////////////////

//
// the motor handler operates with 1ms period.
// a motor period of n indicates one step in n periods
// therefore, period 1 is the shortest possible period
// it will deliver the fastest possible movement.
//

extern unsigned char dm_a_period,			// motor pcm period
		     dm_b_period,
		     dm_c_period;

extern unsigned char dm_a_dir,				// motor direction
		     dm_b_dir,				// must be set from
		     dm_c_dir;				// the patterns below

extern const unsigned char dm_a_pattern[4],		// motor drive patterns
		           dm_b_pattern[4],		// to be indexed with
		           dm_c_pattern[4];		// off, fwd, rev, brake

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// initialize motors
//
void dm_init(void);


//
// shutdown motors
//
void dm_shutdown(void);


//
// set motor directions
//
extern const inline void motor_a_dir(MotorDirection dir) {
	dm_a_dir=dm_a_pattern[dir];
}
extern const inline void motor_b_dir(MotorDirection dir) {
	dm_b_dir=dm_b_pattern[dir];
}
extern const inline void motor_c_dir(MotorDirection dir) {
	dm_c_dir=dm_c_pattern[dir];
}


//
// set motor speeds
//
extern const inline void motor_a_speed(int speed) {
	dm_a_period=1+MAX_SPEED-speed;
}
extern const inline void motor_b_speed(int speed) {
	dm_b_period=1+MAX_SPEED-speed;
}
extern const inline void motor_c_speed(int speed) {
	dm_c_period=1+MAX_SPEED-speed;
}

#endif

#endif
