//
// The unofficial LEGO Mindstorms RCX SDK
// h8.c - H8 specific definitions
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

//
// H8/3297 series registers (FIXME: incomplete)
//

#ifndef __h8_h__
#define __h8_h__

//
// 16 bit timer registers
//
#define T_IER	*((unsigned char*)0xff90)	// interrupt enable
#define T_CSR	*((unsigned char*)0xff91)	// control & status

//
// TIER bitmasks
//
#define TIER_ENABLE_IRQA	0x08	// enable IRQ on compare A


//
// TCSR bitmasks
//
#define TCSR_MATCH_A		0x08	// output compare A

//
// 8 bit timer registers
//
#define STCR	0xffc3		// serial / timer control register

#define T0_CR	0xffc8		// timer 0 control
#define T0_CSR	0xffc9		// timer 0 control / status
#define T0_CORA	0xffca		// timer 0 constant A
#define T0_CORB	0xffcb		// timer 0 constant B
#define T0_CNT	0xffcc		// timer 0 counter

#define T1_CR	0xffd0		// timer 1
#define T1_CSR	0xffd1
#define T1_CORA	0xffd2
#define T1_CORB	0xffd3
#define T1_CNT	0xffd4


//
// CR flag bitmasks
//
#define CR_ENABLE_IRQA		0x40
#define CR_ENABLE_IRQB		0x80
#define CR_ENABLE_IRQO		0x20

#define CR_CLEAR_NEVER		0x00
#define CR_CLEAR_ON_A		0x08	
#define CR_CLEAR_ON_B		0x10
#define CR_CLEAR_ON_EXTERN	0x18

// I don't define speeds here because the STCR bits are involved, too.
// Also, speeds differ for T0 and T1.

//
// CSR bits
//
#define CSR_MATCH_A	0x6
#define CSR_MATCH_B	0x7
#define CSR_OVERFLOW	0x5


//
// Serial port
//
#define S_RDR		*((unsigned char*volatile)0xffdd)	// receive data
#define S_TDR		*((unsigned char*volatile)0xffdb)	// transmit data
#define S_MR		*((unsigned char*volatile)0xffd8)	// mode
#define S_CR		*((unsigned char*volatile)0xffda)	// control
#define S_SR		*((unsigned char*volatile)0xffdc)	// status
#define S_BRR		*((unsigned char*volatile)0xffd9)	// bit rate
#define S_TCR		*((unsigned char*volatile)0xffc3)	// serial/timer ctrl

//
// register bitmasks
//
#define SMR_SYNC	0x80		// in sync mode, the other settings
#define SMR_ASYNC	0x00		// have no effect.
#define SMR_7BIT	0x40
#define SMR_8BIT	0x00
#define SMR_P_NONE	0x00
#define SMR_P_EVEN	0x20
#define SMR_P_ODD	0x30
#define SMR_1STOP	0x00
#define SMR_2STOP	0x08
#define SMR_MP		0x04		// multiprocessing -> no parity
					// for mp, mpe in STRC must be set
#define SMR_CLOCK	0x00		// clock rate for baud rate generator
#define SMR_CLOCK_4	0x01		// pclock / 4
#define SMR_CLOCK_16	0x02		// pclock / 16
#define SMR_CLOCK_64	0x03		// pclock / 64


#define SCR_TX_IRQ	0x80		// TIE transmit irq enable
#define SCR_RX_IRQ	0x40		// RIE receive / recv err irq enable
#define SCR_TRANSMIT	0x20		// enable transmission
#define SCR_RECEIVE	0x10		// enable receiving
#define SCR_MP_IRQ	0x08		// multiprocessing receive irq
#define SCR_TE_IRQ	0x04		// TEI transmit end irq enable
#define SCR_INT_CLOCK	0x00		// internal clock source
#define SCR_EXT_CLOCK	0x02		// external clock source
#define SCR_CLOCK_OUT	0x01		// output internal clock to SCK pin


#define SSR_TRANS_EMPTY	0x80		// transmit buffer empty
#define SSR_RECV_FULL	0x40		// receive buffer full
#define SSR_OVERRUN_ERR	0x20		// overrun error
#define SSR_FRAMING_ERR	0x10		// framing error
#define SSR_PARITY_ERR	0x08		// parity error
#define SSR_TRANS_END	0x04		// transmission end because buffer empty
#define SSR_MP		0x02		// multiprocessor
#define SSR_MP_TRANSFER	0x01		// multiprocessor bit transfer


//
// values for the bit rate register BRR
// assuming CMR_CLOCK selected on 16 MHz processor
// error <= 0.16%
//

#define BAUD_2400	207
#define BAUD_4800	103
#define BAUD_9600	51
#define BAUD_19200	25
#define BAUD_38400	12

#endif
