//
// The unofficial LEGO Mindstorms RCX SDK
// rcx-irq.h - RCX redirected IRQ vectors
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

//
// Lego Mindstorms RCX IRQ redirection vector table (FIXME: incomplete)
// All redirected handlers can assume r6 to be saved
// All redirected handlers must return with rts, *not* rte.
//

#ifndef __rcx_irq_h__
#define __rcx_irq_h__

#define OCIA_IRQ	*((void**)0xfda2)	// 16-bit Timer Output Compare A

#define	T0_IRQA		*((void**)0xfda8)	// Timer 0 CMI0A
#define T0_IRQB		*((void**)0xfdaa)	//         CMI0B  
#define T0_IRQO		*((void**)0xfdac)	//         OVI0  

#define	T1_IRQA		*((void**)0xfdae)	// Timer 1 CMI1A  
#define T1_IRQB		*((void**)0xfdb0)	//         CMI1B  
#define T1_IRQO		*((void**)0xfdb2)	//         OVI1  

#define RX_ERROR_IRQ	*((void**)0xfdb4)	// Serial  ERI receive error
#define RX_IRQ		*((void**)0xfdb6)	//         RXI byte received
#define TX_IRQ		*((void**)0xfdb8)	//	   TXI transmit buffer empty
#define TX_END_IRQ	*((void**)0xfdba)	//         TEI transmit end

#define AD_IRQ		*((void**)0xfdbe)	// A/D converter
#define WATCHDOG_IRQ	*((void**)0xfdbe)	// Watchdog timer interrupt vector


//
// convenient macros
//

#define disable_irqs()	__asm__ __volatile__("orc  #0x80,ccr\n":::"cc")
#define enable_irqs()	__asm__ __volatile__("andc #0x7f,ccr\n":::"cc")


//
// An RCX-specific I/O address
//

#define	 RCX_MOTORS	*((unsigned char*) 0xf000)	// motor drivers


#endif
