//
// The unofficial LEGO Mindstorms RCX SDK
// rcx-rom.h - allows access to RCX ROM functionality
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __rcx_rom_h__
#define __rcx_rom_h__

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// FIXME: register clobbers
//

// power off
extern void power_off(void) __asm__ ("0x2a62");

// power init
extern void power_init(void) __asm__ ("0x2964");

// rom reset, kill firmware.
extern void rom_reset(void) __asm__ ("0x03ae") __attribute__ ((noreturn));

// tell rom we are the firmware.
// may need a curious RAM initialization, too.
extern inline void set_firmware(void) { 
__asm__ __volatile__(
        "mov.w    #0xc000,r6\n"
        "mov.w    r6,@-r7\n"
        "mov.w    #0xc006,r6\n"
        "jsr      0x3b9a\n"
        "adds     #0x2,r7\n"
        :                                       // output
        :                                       // input
        : "r6","cc","memory"                    // clobbered
        );
}


#endif
