//
// lcd-test.c - let's have some lights here!
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#include "rcx-rom.h"
#include "rcx-lcd.h"

lcd_segment outer[]={s1_active,s1_select,
		     s2_active,s2_select,
		     s3_active,s3_select,
		     c_right,c_select,c_left,
		     b_right,b_select,b_left,
		     a_right,a_select,a_left};

void delay(unsigned ms) {
	unsigned i;
	while(ms-->0)
		for(i=0; i<600; i++)			// not well calibrated.
			;
}

int main(void) {
	int i,j;

	for(i=-500; i<=500; i++) {			// numbers
		lcd_int(i);
		lcd_refresh();
		delay(10);
	}

//	lcd_clear();		// note: firmware should know how to erase 
//	lcd_show(man_stand);	//       numbers only (view button...)
	for(i=9; i>=0; i--) {				// more numbers
		lcd_digit(i);
		lcd_refresh();
		delay(500);
	}
//	lcd_clear();
//	lcd_show(man_stand);	
//	lcd_refresh();	
	
	for(j=0; j<5; j++) {
		lcd_show(dot);			// let dots run
				
		for(i=0; i<15; i++) {
			lcd_show(outer[i]);	// outer lights
			
			if((i+j)&1)			// man runs
				lcd_show(man_stand);
			else
				lcd_show(man_run);
			
			if(j>0)
				if(i&2)			// toggle IR slowly
					lcd_show(ir_full);
				else
					lcd_show(ir_half);
				
			if(j>2)				// circle quickly
				lcd_show(circle);

			lcd_refresh();
			delay(250);

			lcd_hide(outer[i]);
		}
	}
					
	lcd_clear();
	lcd_show(dot);				// kill dots.
	lcd_show(man_stand);
	lcd_show(battery_x);			// running low?
	lcd_refresh();
	sound_system(4);
	delay(1000);
	
	return 0;
}
