//
// The unofficial LEGO Mindstorms RCX SDK
// rcx-rom.h - allows access to RCX ROM functionality
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __rcx_rom_h__
#define __rcx_rom_h__

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// FIXME: register clobbers
//

// copy memory block [src,end] to [dest,(dest+end-src)]
extern inline void mem_copy(void* dest,void* src,void* end) {
	register void* _dest __asm__ ("r2")=dest;
	register void* _src  __asm__ ("r0")=src;
	register void* _end  __asm__ ("r1")=end;
__asm__ __volatile__(
	"jsr @0x042a:0"
	);					
}

// set memory block [start,end] to zero
extern inline void mem_clear(void* start,void* end) {
	register void* _start __asm__ ("r0")=start;
	register void* _end   __asm__ ("r1")=end;
__asm__ __volatile__(
	"jsr @0x0436:0"
	);					
}

// power off
extern void power_off(void) __asm__ ("0x2a62");

// play one of the system sounds.
extern inline void sound_system(unsigned nr) {
__asm__ __volatile__(
	"mov.w %0,@-r7\n"
	"mov.w #0x4003,r6\n"
	"jsr @0x299a:0\n"
	"adds #0x2,r7\n"
	:					// output
	: "r" (nr)				// input
	: "r6","memory"				// clobbered
	);
}

// is a sound playing? 0=no, else yes
// FIXME: seems to be broken.
extern inline int sound_playing() {
	unsigned rc;
__asm__ __volatile__(
	"mov.w r7,r6\n"
	"mov.w r6,@-r7\n"
	"mov.w #0x700c,r6\n"
	"jsr @0x3ccc:0\n"
	"adds #0x2,r7\n"
	"mov.w @r7,%0\n"
	: "=r" (rc)				// output
	:					// input
	: "r6","memory"				// clobbered
	);
	return rc;
}	

#endif
