//
// The unofficial LEGO Mindstorms RCX SDK
// mem.h - memory functions.
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __mem_h__
#define __mem_h__


///////////////////////////////////////////////////////////////////////////////
//
// Definitions
//
///////////////////////////////////////////////////////////////////////////////

#define NULL		((void*)0)		// null pointer

typedef unsigned	size_t;			// data type for memory sizes


///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

// copy size bytes of memory from src to dest
extern inline void memcpy(void* dest,void* src,size_t size) {
	register void* _src  __asm__ ("r0")=src;
	register size_t _end  __asm__ ("r1")=size;
	register void* _dest __asm__ ("r2")=dest;
__asm__ __volatile__(
	"add.w r0,r1\n"
	"jsr @0x042a:0"
	: 					// output
	:					// input
	: "r0","r1","r2","r3","cc","memory"	// clobbered (final)
	);					
}

// memset - fill memory with a constant byte
extern inline void *memset(void* s,int c,size_t n) {
	void *res;
__asm__ __volatile__(
	"  add.w %1,%0\n"
	"0:cmp.w %1,%0\n"
	"  beq 1f\n"
	"  mov.b %2l,@-%0\n"
	"  bra 0b\n"
	"1:"
	: "=r" (res)				// output
	: "r" (s), "r" (c), "0" (n)		// input
	: "cc","memory"				// clobbered (final)
	);
	return res;					
}

// set memory block [start,end[ to zero
// FIXME: seems buggy. advise memset()
extern inline void mem_clear(void* start,void* end) {
	register void* _start __asm__ ("r0")=start;
	register void* _end   __asm__ ("r1")=end;
__asm__ __volatile__(
	"jsr @0x0436:0"
	: 					// output
	:					// input
	: "r0","r1","r2","cc","memory"		// clobbered (final)
	);					
}

#endif
