//
// The unofficial LEGO Mindstorms RCX SDK
// rcx-sound.h - allows access to RCX sound
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __rcx_sound_h__
#define __rcx_sound_h__


///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// FIXME: register clobbers
//

// play one of the system sounds.
extern inline void sound_system(unsigned nr) {
__asm__ __volatile__(
	"mov.w %0,@-r7\n"
	"mov.w #0x4003,r6\n"
	"jsr @0x299a:0\n"
	"adds #0x2,r7\n"
	:					// output
	: "r" (nr)				// input
	: "r6","cc","memory"			// clobbered
	);
}

// is a sound playing? 0=no, else yes
extern inline int sound_playing() {
	unsigned rc;
__asm__ __volatile__(
	"mov.w r7,r6\n"
	"mov.w r6,@-r7\n"
	"mov.w #0x700c,r6\n"
	"jsr @0x3ccc:0\n"
	"adds #0x2,r7\n"
	"mov.w @r7,%0\n"
	: "=r" (rc)				// output
	:					// input
	: "r6","cc","memory"			// clobbered
	);
	return rc;
}	

#endif
