//
// The unofficial LEGO Mindstorms RCX SDK
// bitops.h - H8/300 bit operations
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __bitops_h__
#define __bitops_h__


///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// the H8/300 processor offers many useful  bit operations.
// sometimes, we have to help gcc to realize their full 
// potential.
//
// the bit operations don't alter cc except for bld
//

//
// set a single bit in memory
// *((char*)byte)|=(1<<bit)
//
#define bit_set(byte,bit)	\
__asm__ const ( "bset %0,@%1\n" : : "i" (bit),"r" (byte))

//
// clear a single bit in memory
// ((char*)byte)&=~(1<<bit)
//
#define bit_clear(byte,bit)	\
__asm__ const ( "bclr %0,@%1\n" : : "i" (bit),"r" (byte))

//
// load a single bit from a mask to the carry flag
// carry=mask & (1<<bit)
//
#define bit_load(mask,bit)	\
__asm__ const ( "bld %0,%1l\n" : : "i" (bit),"r" (mask):"cc")

//
// store the carry flag to a single single bit in memory
// *((char*)byte)= ( (*((char*)byte)) & (~(1<<bit)) ) | (carry<<bit)
//
#define bit_store(byte,bit)	\
__asm__ const ( "bst %0,@%1\n" : : "i" (bit),"r" (byte))

#endif
