//
// The unofficial LEGO Mindstorms RCX SDK
// conio.h - console input / output
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __conio_h_
#define __conio_h_

#ifndef NO_CONSOLE_IO

#define SCROLL_DELAY	500		// scroll delay for cputs

///////////////////////////////////////////////////////////////////////////////
//
// Definitions
//
///////////////////////////////////////////////////////////////////////////////

//
// hex display codes
//
extern const char hex_display_codes[];

#ifndef NO_ASCII

//
// ascii display codes
// only lower 128 bit, please!
//
extern const char ascii_display_codes[];
		
#endif	// NO_ASCII

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// delay by approximately d ms
// 
extern void delay(unsigned d);


//
// display native mode segment mask at fixed display position
//
// encoding: middle=1, topr=2, top=4, ... (counterclockwise)
// dot not included because not reliably present.
//
extern void cputc_native_0(char mask);
extern void cputc_native_1(char mask);
extern void cputc_native_2(char mask);
extern void cputc_native_3(char mask);
extern void cputc_native_4(char mask);
extern void cputc_native_5(char mask);

// a dispatcher for the fixed position versions
extern void cputc_native(char mask,int pos);


//
// display a hexword
//
extern void cputw(unsigned word);


#ifndef NO_ASCII

//
// display ascii character c at display position pos
//
extern inline void cputc(unsigned char c,int pos) {
	if(c>=128)
		c-=128;
	cputc_native(ascii_display_codes[c],pos);
}


//
// display a zero terminated string s
//
extern void cputs(unsigned char *s);

#endif	// NO_ASCII

#endif	// NO_CONSOLE_IO

#endif
