//
// The unofficial LEGO Mindstorms RCX SDK
// direct-button.h - get button states
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __direct_button_h__
#define __direct_button_h__

///////////////////////////////////////////////////////////////////////////////
//
// Definitions
//
///////////////////////////////////////////////////////////////////////////////

//
// the button bitmasks
// buttons at @0xb7:8 and @0xbe:8
//

#define	BUTTON_ONOFF	0x0002		// 0x02 @ 0xffb7
#define BUTTON_RUN	0x0004		// 0x04 @ 0xffb7
#define BUTTON_VIEW	0x4000		// 0x40 @ 0xffbe
#define BUTTON_PROGRAM	0x8000		// 0x80 @ 0xffbe

//
// buttons are active low
//

#define RELEASED(state,button)	((state) & (button)) 
#define PRESSED(state,button)	(!RELEASED(state,button))


///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// get button states
// masks defined above
//
extern inline int button_state(void) {
	int rv;
__asm__ __volatile__(
	"mov.b @0xb7:8,%0l\n"
	"mov.b @0xbe:8,%0h\n"
	: "=r" (rv)				// output
	: 					// input
	: "cc"					// clobbered
	);
	return rv;
}


#endif
