//
// The unofficial LEGO Mindstorms RCX SDK
// mm-internal.h - internal dynamic memory management
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __mm_internal_h__
#define __mm_internal_h__

#ifndef NO_MEMORY_MANAGEMENT

#include "mem.h"
#include "stdlib.h"


///////////////////////////////////////////////////////////////////////////////
//
// Definitions
//
///////////////////////////////////////////////////////////////////////////////

//
// special block owners.
//

#define MM_FREE		0x0000
#define MM_RESERVED	0xffff

//
// as data generally nees to be word aligned, 1 unit ^= 2 bytes
//

#define MM_HEADER_SIZE	2			// 2 words header: pid, size
#define MM_SPLIT_THRESH	(MM_HEADER_SIZE+8)	// split off if 16+ data bytes
						// left.

extern size_t mm_start;				// start of memory managed area
						// end is end of segment.

extern size_t* mm_first_free;			// ptr to first free memory
						// block.

//
// Macros for mm_init()
//

//
// memory from addr on can be allocated
//
#define MM_BLOCK_FREE(addr) 					\
	next=(size_t*)(addr);					\
	*current=((((size_t)next)-(size_t)current)-2)>>1;	\
	*(next++)=MM_FREE;					\
	current=next;
	

//
// memory from addr on is reserved
//	
#define MM_BLOCK_RESERVED(addr) 				\
	next=(size_t*)(((size_t)addr)-4);			\
	*current=((((size_t)next)-(size_t)current)-2)>>1;	\
	*(next++)=MM_RESERVED;					\
	current=next;

								
///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

// initialize memory management
extern void mm_init();

// free all blocks allocated by the current process
extern void mm_reaper();

#endif	// NO_MEMORY_MANAGEMENT

#endif
