//
// The unofficial LEGO Mindstorms RCX SDK
// semaphores.h - POSIX 1003.1b semaphores for process synchronization.
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __semaphores_h__
#define __semaphores_h__

///////////////////////////////////////////////////////////////////////////////
//
// Definitions
//
///////////////////////////////////////////////////////////////////////////////

// right now, this is a naive implementation. tasks just poll the 
// semaphore.

typedef unsigned char sem_t;


///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////


extern inline int sem_init(sem_t *sem, int pshared, unsigned int value) {
	*sem=(sem_t) value;
	return 0;
}

extern inline int sem_wait(sem_t * sem) {
}

//
//  sem_trywait is a non-blocking variant of sem_wait.  If the
//  semaphore pointed to by sem has non-zero count, the  count
//  is   atomically   decreased  and  sem_trywait  immediately
//  returns 0.  If the semaphore count  is  zero,  sem_trywait
//  immediately returns with error EAGAIN.
// 
extern inlinie int sem_trywait(sem_t * sem) {
	int rv;
__asm__ __volatile__(
	"mov.w %0,r0\n"
	"orc 0x80\n"				// block all but NMI
	"mov.b @r0,%0l\n"
	"bz 0f\n"
	"   dec %0l\n"
	"   mov.b %0l,@r0\n"
	"   andc 0x7f\n"			// enable interrupts
	"   sub.w %0,%0\n"
	"   bra 1f\n"
	"0f:andc 0x7f\n"			// enable interrupts
	"   mov #0xffff,%0\n"
	"1f:"
	:"=r" (rv)				// input
	:"0" (sem)				// output
	:"r0","cc"				// clobbered
	);
	return rv;
}

//
//  sem_post  atomically  increases the count of the semaphore
//  pointed to by sem.  This function  never  blocks  and  can
//  safely be used in asynchronous signal handlers.
//
// FIXME: not so sure about that. if interrupts are already masked,
//        they will be enabled afterwards!
extern inline int sem_post(sem_t * sem) {
	int rv;
__asm__ __volatile__(
	"mov.w %0,r0\n"
	"orc 0x80\n"				// disable all but NMI
	"mov.b @r0,%0l\n"
	"inc %0l\n"
	"mov.b %0l,@r0\n"
	"andc 0x7f\n"				// enable interrupts
	:"=r" ()				// input
	:"0" (sem)				// output
	:"r0","cc"				// clobbered
	);
	return 0;
}

extern inline int sem_getvalue(sem_t * sem, int * sval) {
	*sval=*sem;
	return 0;
}

extern inline int sem_destroy(sem_t * sem) {
	// this should check whether processes are waiting.
	return 0;
}
 

#endif
