//
// The unofficial LEGO Mindstorms RCX SDK
// stdlib.h - reduced standard C library
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __stdlib_h__
#define __stdlib_h__

#include "mem.h"


///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// Standard memory management.
// See the Linux man pages for details.
//

extern void *calloc(size_t nmemb, size_t size);

extern void *malloc(size_t size);

extern void free(void *ptr);

//
// 16 bit multiplication
//
extern inline unsigned mul16(unsigned uu1,unsigned uu2) {
	register unsigned u1 __asm__ ("r6")=uu1;
	register unsigned u2 __asm__ ("r5")=uu2;
__asm__ __volatile__(
	"jsr @0x0130:0"
	: 					// output
	:					// input
	: "cc"					// clobbered (final)
	);
	return u1;	
}

#endif
