//
// The unofficial LEGO Mindstorms RCX SDK
// tm-internal.h - task management interna
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#ifndef __tm_internal_h__
#define __tm_internal_h__

#ifndef NO_TASK_MANAGEMENT

#include "tm.h"


///////////////////////////////////////////////////////////////////////////////
//
// Definitions
//
///////////////////////////////////////////////////////////////////////////////

#define STCR	0xffc3		// serial / timer control register

#define T0_CR	0xffc8		// timer 0 control
#define T0_CSR	0xffc9		// timer 0 control / status
#define T0_CORA	0xffca		// timer 0 constant A
#define T0_CORB	0xffcb		// timer 0 constant B
#define T0_CNT	0xffcc		// timer 0 counter

#define T1_CR	0xffd0		// timer 1
#define T1_CSR	0xffd1
#define T1_CORA	0xffd2
#define T1_CORB	0xffd3
#define T1_CNT	0xffd4


#define SP_RETURN_OFFSET	9	// offset of return address on stack
					// in words.
					
///////////////////////////////////////////////////////////////////////////////
//
// Variables
//
///////////////////////////////////////////////////////////////////////////////

extern process_data pd_single;			// single process process data

extern process_data *cpid;			// ptr to current process data


///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

//
// init task management
// called in single tasking mode before task setup.
//
extern void tm_init(void);


//
// start task management 
// called in single tasking mode after task setup
//
extern void tm_start(void);

	
//
// shutdown task management
// called by scheduler in multitasking mode
//
extern void tm_stop(void);


//
// the task switcher IRQ handler
// located in the assembler process module
//
extern void tm_switcher(void);


//
// the process scheduler
// arg   : current task's current stack pointer
// retval: new task's current stack pointer
//
// actual context switches performed by tm_switcher (assembler wrapper)
//
extern size_t *tm_scheduler(size_t *old_sp);


//
// the idle task
// infinite sleep instruction
//
extern void tm_idle_task(void);


#endif

#endif
