//
// The unofficial LEGO Mindstorms RCX SDK
// tm2-test.c - task managment test
// (c) 1998 by Markus L. Noga <noga@inrialpes.fr>    
//

#include "tm.h"

#include "rcx-lcd.h"
#include "conio.h"
#include "direct-button.h"
#include "direct-motor.h"

pid_t t1,t2,t3;

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

int task1(void) {
	unsigned int j=0;
	
	while(1) {
		cputw(j++);
		lcd_refresh();
	}
}

int task2(void) {
	int i;
	while(1) {
		motor_a_dir(fwd);
		motor_c_dir(fwd);
		for(i=MIN_SPEED; i<=MAX_SPEED; i++) {
			motor_a_speed(i);
			motor_c_speed(i);
			delay(1000);
		}
	
		motor_a_dir(rev);
		motor_c_dir(rev);

		for(i=MAX_SPEED; i>=MIN_SPEED; i--) {
			motor_a_speed(i);
			motor_c_speed(i);
			delay(1000);
		}
	}
}		

int button_wakeup(int data) {
	return PRESSED(button_state(),data);
}

int task3(void) {
	wait_event(&button_wakeup,BUTTON_RUN);
	kill(t1);
	kill(t2);
	return 0;
}

int main(void) {
	while(PRESSED(button_state(),BUTTON_RUN))	// debounce
		;
	delay(150);

	t1=execi(&task1,DEFAULT_STACK_SIZE);
	t2=execi(&task2,DEFAULT_STACK_SIZE);
	t3=execi(&task3,DEFAULT_STACK_SIZE);
	
	tm_start();					// brace yourself!
	
	return 0;
}	
